#!/bin/bash

RED='\033[0;31m'
BLUE='\033[0;34m'
RESET='\033[0m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
llime='\033[38;5;10m'

#if dpkg  -l | grep -q "curl"; then
if dpkg-query -W -f='${Status}' curl 2>/dev/null | grep -q "ok installed"; then
echo " " 
else
clear
echo -e "${YELLOW}#############################${RESET}"
echo -e "${YELLOW}### ${llime}Menedżer Aktualizacji ${YELLOW}###${RESET}"
echo -e "${YELLOW}#############################${RESET}"
echo " "
echo "Aby Aktualizacje działały wymagany jest pakiet curl"
echo "Zainstalować niezbędne pakiety ? [y/n]"
read option
case $option in
"y")
echo "Instalacja niezbędnych pakietów.."
sleep 1
sudo apt update
sudo apt install curl -y
;;
"n")
exit 0
;;
*)
echo "Niepoprawna opcja, wybierz [y/n]"
sleep 1
"$0"
exit 0
;;
esac
fi


# Lokalne informacje o wersji
#=====================================
local_version="1.0.1"  
#=====================================
clear
echo -e "${YELLOW}#############################${RESET}"
echo -e "${YELLOW}### ${llime}Menedżer Aktualizacji ${YELLOW}###${RESET}"
echo -e "${YELLOW}#############################${RESET}"
echo " "


echo -e "${YELLOW}================================================${RESET}"
echo -e "${YELLOW}1${RESET} - ${llime}Sprawdź i Zainstaluj dostepne aktualizacje${RESET}"
echo -e "${YELLOW}2${RESET} - Sprawdź obecną wersję aplikacji"
echo -e "${YELLOW}3${RESET} - Sprawdź dostępność nowej wersji aplikacji"
echo -e "${YELLOW}4${RESET} - Przeczytaj o zmianach w obecnej wersji"
echo -e "${YELLOW}5${RESET} - Exit"
echo -e "${YELLOW}================================================${RESET}"
read operation
case $operation in
1)
# URL do pliku z wersją na serwerze
version_url="http://msox-kalkulator.ct8.pl/version.txt"

# URL do pliku ZIP z aplikacją na serwerze
zip_url="http://msox-kalkulator.ct8.pl/pobierz/MSOX_kalkulator.zip"

# Lokalizacja docelowa dla pliku ZIP i rozpakowanej aplikacji
download_dir=".rejestr/.aktualizacje"
app_dir="../"

# Tworzenie katalogu docelowego, jeśli nie istnieje
mkdir -p $download_dir

# Pobranie wersji z serwera
remote_version=$(curl -s $version_url)

# Sprawdzenie czy curl zakończył się sukcesem i czy remote_version nie jest pusty
if [ $? -eq 0 ] && [ -n "$remote_version" ]; then
    #echo "Lokalna wersja: $local_version"
    #echo "Zdalna wersja: $remote_version"

    if [ "$local_version" != "$remote_version" ]; then
        echo "Dostępna jest nowsza wersja aplikacji!"
        echo "Pobieranie nowej wersji..."

        # Pobranie pliku ZIP z nową wersją do określonego katalogu
        curl -o "${download_dir}/MSOX_kalkulator.zip" "$zip_url"

        if [ $? -eq 0 ]; then
            echo "Pobieranie zakończone sukcesem."
            echo "Rozpakowywanie nowej wersji..."

            # Rozpakowywanie pliku ZIP do katalogu aplikacji, nadpisując tylko istniejące pliki z ZIP
            unzip -o "${download_dir}/MSOX_kalkulator.zip" -d "$download_dir/"
	    if [ -e "$download_dir/MSOX_kalkulator" ]; then
	    cp -r "${download_dir}/MSOX_kalkulator/kalkulator" "$app_dir"
	    else
	    cp -r "${download_dir}/kalkulator" "$app_dir"
	    fi

            if [ $? -eq 0 ]; then
                echo "Aktualizacja zakończona sukcesem."

                # Usunięcie pobranego pliku ZIP
                sudo rm -r "$download_dir/"
		sudo chmod -R 777 "../kalkulator"
		read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
		"$0"
        exit 0
            else
                echo "Błąd podczas rozpakowywania pliku ZIP."
            fi
        else
            echo "Błąd podczas pobierania pliku ZIP."
        fi
    else
        echo -e "${BLUE}===========================${RESET}"
	echo -e "Posiadasz najnowszą wersję."
	echo -e "${BLUE}===========================${RESET}"
    echo " "
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    fi
else
    echo "Nie udało się sprawdzić wersji zdalnej."
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
fi
;;
2)
echo -e "${BLUE}======================${RESET}"
echo -e "Obecna wersja: ${RED}${local_version}${RESET}"
echo -e "${BLUE}======================${RESET}"
read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
"$0"
exit 0
;;
3)
# URL do pliku z wersją na serwerze
version_url="http://msox-kalkulator.ct8.pl/version.txt"
# Pobranie wersji z serwera
remote_version=$(curl -s $version_url)
# Sprawdzenie czy curl zakończył się sukcesem i czy remote_version nie jest pusty
if [ $? -eq 0 ] && [ -n "$remote_version" ]; then
    if [ "$local_version" != "$remote_version" ]; then
	echo -e "${BLUE}============================================${RESET}"
	echo -e "Dostępna jest nowsza wersja aplikacji: ${RED}${remote_version}${RESET}"
	echo -e "${BLUE}============================================${RESET}"
    else
	echo -e "${BLUE}===========================${RESET}"
	echo -e "Posiadasz najnowszą wersję."
	echo -e "${BLUE}===========================${RESET}"
    fi
else
    echo "Nie udało się sprawdzić wersji zdalnej; Sprawdz swoje połączenie internetowe i spróbuj ponownie."
fi
read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
"$0"
exit 0
;;
4)
echo ""
echo -e "${llime}W wersji ${RED}1.0.1 ${llime}wprowadzono:"
echo -e "${BLUE}
> Kalkulator prosty, zaawansowany, programisty"
read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
"$0"
exit 0
;;
5)

exit 0
;;

*)

"$0"
exit 0
;;

esac
"$0"
exit 0
