#!/bin/bash
clear
RED='\033[0;31m'
BLUE='\033[38;5;45m'
RESET='\033[0m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
llime='\033[38;5;10m'
AQUA='\033[38;5;51m'
ROSE='\033[38;5;201m'

text1='\033[38;5;231m'
tlo1='\033[48;5;20m'
KOMUNICATE="${text1}${tlo1}"

text2='\033[38;5;17m'
tlo2='\033[48;5;123m'
DATA="${text2}${tlo2}"


is_number() {
    local num="$1"
    if [[ "$num" =~ ^-?[0-9]+(.[0-9]+)?$ ]]; then
        echo " "
    else
        echo -e "Podana wartość nie jest liczbą.${RED} Zakończono w stanie błędu. ${RESET}"
        read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        "$0"
        exit 0
    fi
}

echo -e "${YELLOW}#########################"
echo -e "${YELLOW}###${llime} Kalkulator Prosty ${YELLOW}###"
echo -e "${YELLOW}#########################"
echo " "
echo -e "${BLUE}===========================${RESET}"
echo -e "${llime}Operacje:"
echo -e "${llime}> ${RED}1${BLUE},${RED} + ${BLUE}Dodawanie"
echo -e "${llime}> ${RED}2${BLUE},${RED} - ${BLUE}Odejmowanie"
echo -e "${llime}> ${RED}3${BLUE},${RED} * ${BLUE}Mnożenie"
echo -e "${llime}> ${RED}4${BLUE},${RED} / ${BLUE}Dzielenie"
echo -e "${llime}> ${RED}5${BLUE},${RED} % ${BLUE}Reszta z dzielenia"
echo -e "${llime}> ${RED}6${BLUE} Pierwiastek 2 stopnia"
echo -e "${llime}> ${RED}7${BLUE} Potęgowanie"
echo -e "${llime}> ${RED}8${RED} Exit"
echo -e "${BLUE}===========================${RESET}"
echo " "
echo "Podaj numer lub symbol operacji"
read operation
case $operation in 
    "+" | 1)
    #===================================================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"
    echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
    read druga
    echo -e "${RESET}"
    is_number "$druga"
    
    wynik=$(echo "scale=6; $pierwsza+$druga" | bc)
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    "-" | 2)
    #===================================================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"
    echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
    read druga
    echo -e "${RESET}"
    is_number "$druga"
    
    wynik=$(echo "scale=6; $pierwsza-(${druga})" | bc)
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    "*" | 3)
    #===================================================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"
    echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
    read druga
    echo -e "${RESET}"
    is_number "$druga"
    
    wynik=$(echo "scale=6; $pierwsza*(${druga})" | bc)
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    "/" | 4)
    #===================================================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"
    echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
    read druga
    echo -e "${RESET}"
    is_number "$druga"
    
    wynik=$(echo -e "scale=6\n; $pierwsza/$druga" | bc)
    wynik=$(echo $wynik | sed 's/\.0*$//; s/\.\([0-9]*[1-9]\)0*$/.\1/')
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    "%" | 5)
    #===================================================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"
    echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
    read druga
    echo -e "${RESET}"
    is_number "$druga"
    
    wynik=$(echo "$pierwsza%$druga" | bc)
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    6)
    #===================================================
    echo -e "${KOMUNICATE}Podaj wartość do spierwiastkowania:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"
    
    wynik=$(echo "scale=6; sqrt($pierwsza)" | bc)
    wynik=$(echo $wynik | sed 's/\.0*$//; s/\.\([0-9]*[1-9]\)0*$/.\1/')
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    7)
    #===================================================
    echo -e "${KOMUNICATE}Podaj wartość podstawy potęgi:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    is_number "$pierwsza"

    echo -e "${KOMUNICATE}Podaj wartość wykładnika potęgi:${DATA}"
    read druga
    echo -e "${RESET}"
    is_number "$druga"
    
    wynik=$(echo "scale=6; $pierwsza^$druga" | bc)
    echo -e "${YELLOW}=============================${RESET}"
    echo -e "${llime} Wynik: $wynik"
    echo -e "${YELLOW}=============================${RESET}"
    read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
    "$0"
    exit 0
    #===================================================
    ;;
    "exit" | "e" | "-e" | 8)
    exit 0
    ;;
    *)
    echo "Niepoprawny argument operacji"
    sleep 1
    "$0"
    exit 0
    ;;
esac

