#!/bin/bash

clear
RED='\033[0;31m'
BLUE='\033[38;5;45m'
RESET='\033[0m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
llime='\033[38;5;10m'
AQUA='\033[38;5;51m'
ROSE='\033[38;5;201m'

text1='\033[38;5;231m'
tlo1='\033[48;5;20m'
KOMUNICATE="${text1}${tlo1}"

text2='\033[38;5;17m'
tlo2='\033[48;5;123m'
DATA="${text2}${tlo2}"

decymal() {
    local num="$1"
    if [[ "$num" =~ ^-?[0-9]+$ ]]; then
        echo " "
        return 0
    else
        echo -e "Podana wartość nie jest całkowitą liczbą dziesiętną.${RED} Zakończono w stanie błędu. ${RESET}"
        read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        return 1
    fi
}
octal() {
    local num="$1"
    if [[ "$num" =~ ^-?[0-7]+$ ]]; then
        echo " "
        return 0
    else
        echo -e "Podana wartość nie jest całkowitą liczbą ósemkową.${RED} Zakończono w stanie błędu. ${RESET}"
        read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        return 1
    fi
}
binary() {
    local num="$1"
    if [[ "$num" =~ ^-?[0-1]+$ ]]; then
        echo " "
        return 0
    else
        echo -e "Podana wartość nie jest całkowitą liczbą dwójkową.${RED} Zakończono w stanie błędu. ${RESET}"
        read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        return 1
    fi
}
hex() {
    local num="$1"
    if [[ "$num" =~ ^-?[0-9A-Fa-f]+$ ]]; then
        echo " "
        return 0
    else
        echo -e "Podana wartość nie jest całkowitą liczbą szestnastkową.${RED} Zakończono w stanie błędu. ${RESET}"
        read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        return 1
    fi
}

echo -e "${YELLOW}##################################"
echo -e "${YELLOW}###${AQUA} Kalkulator Programistyczny ${YELLOW}###"
echo -e "${YELLOW}##################################"
echo " "
echo -e "${BLUE}===========================${RESET}"
echo -e "${llime}Operacje:"
echo -e "${llime}> ${RED}1${BLUE},${RED} + ${BLUE}Dodawanie"
echo -e "${llime}> ${RED}2${BLUE},${RED} - ${BLUE}Odejmowanie"
echo -e "${llime}> ${RED}3${BLUE},${RED} * ${BLUE}Mnożenie"
echo -e "${llime}> ${RED}4${BLUE},${RED} / ${BLUE}Dzielenie"
echo -e "${llime}> ${RED}5${BLUE},${RED} % ${BLUE}Reszta z dzielenia"
echo -e "${llime}> ${RED}6${BLUE} Konwersja "
echo -e "${llime}> ${RED}7${RED} Exit"
echo -e "${BLUE}===========================${RESET}"
echo "Podaj numer lub symbol operacji"
read operation
case $operation in 
    "+" | 1)

    #===================================================
    #====================================
    
    kontrol=1
    while [ $kontrol = 1 ]; do
    clear
    echo -e "${AQUA}#################"
    echo -e "${AQUA}###${RESET} Dodawanie ${AQUA}###"
    echo -e "${AQUA}#################"
    echo " "
    echo -e "${BLUE}======================${RESET}"
    echo -e "${llime}> ${RED}1${BLUE}, ${RED}d ${BLUE}Dziesiętny"
    echo -e "${llime}> ${RED}2${BLUE}, ${RED}b ${BLUE}Dwójkowy"
    echo -e "${llime}> ${RED}3${BLUE}, ${RED}o ${BLUE}Ósemkowy"
    echo -e "${llime}> ${RED}4${BLUE}, ${RED}h ${BLUE}Szesnastkowy"
    echo -e "${llime}> ${RED}5 Exit"
    echo -e "${BLUE}======================${RESET}"
    echo -e "Podaj numer/symbol systemu liczbowego w którym chcesz wykonać obliczenia"
    read opt
    case $opt in
    "d" | 1)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    decymal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            decymal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "$pierwsza+$druga" | bc)
                wynikb=$(echo "obase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynik" | bc)
                wynikh=$(echo "obase=16; $wynik" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "b" | 2)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    binary "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            binary "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=2; obase=2; $pierwsza+$druga" | bc)
                wynikd=$(echo "ibase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "o" | 3)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    octal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            octal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=8; obase=8; $pierwsza+$druga" | bc)
                wynikd=$(echo "ibase=8; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "h" | 4)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    hex "$pierwsza"
    echo -e "${RESET}"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            hex "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                pierwszaa=$(echo "$pierwsza" | tr 'a-f' 'A-F')
                drugaa=$(echo "$druga" | tr 'a-f' 'A-F')
                wynik=$(echo "ibase=16; $pierwszaa+$drugaa" | bc)
                wynik=$(echo "obase=16; $wynik" | bc)
                wynikd=$(echo "ibase=16; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "exit" | "e" | "-e" | 5)
    kontrolna=0
    "$0"
    exit 0
    ;;
    *)
    echo "Niepoprawna opcja"
    sleep 1
    kontrolna=1
    ;;
    esac
    done
    #===================================================
    ;;

    "-" | 2)
    #===================================================
    #====================================
    
    kontrol=1
    while [ $kontrol = 1 ]; do
    clear
    echo -e "${AQUA}###################"
    echo -e "${AQUA}###${RESET} Odejmowanie ${AQUA}###"
    echo -e "${AQUA}###################"
    echo " "
    echo -e "${BLUE}======================${RESET}"
    echo -e "${llime}> ${RED}1${BLUE}, ${RED}d ${BLUE}Dziesiętny"
    echo -e "${llime}> ${RED}2${BLUE}, ${RED}b ${BLUE}Dwójkowy"
    echo -e "${llime}> ${RED}3${BLUE}, ${RED}o ${BLUE}Ósemkowy"
    echo -e "${llime}> ${RED}4${BLUE}, ${RED}h ${BLUE}Szesnastkowy"
    echo -e "${llime}> ${RED}5 Exit"
    echo -e "${BLUE}======================${RESET}"
    echo -e "Podaj numer/symbol systemu liczbowego w którym chcesz wykonać obliczenia"
    read opt
    case $opt in
    "d" | 1)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    decymal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            decymal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "$pierwsza-($druga)" | bc)
                wynikb=$(echo "obase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynik" | bc)
                wynikh=$(echo "obase=16; $wynik" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "b" | 2)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    binary "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            binary "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=2; obase=2; $pierwsza-($druga)" | bc)
                wynikd=$(echo "ibase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "o" | 3)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    octal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            octal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=8; obase=8; $pierwsza-($druga)" | bc)
                wynikd=$(echo "ibase=8; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "h" | 4)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    hex "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            hex "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                pierwszaa=$(echo "$pierwsza" | tr 'a-f' 'A-F')
                drugaa=$(echo "$druga" | tr 'a-f' 'A-F')
                wynik=$(echo "ibase=16; $pierwszaa-($drugaa)" | bc)
                wynik=$(echo "obase=16; $wynik" | bc)
                wynikd=$(echo "ibase=16; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "exit" | "e" | "-e" | 5)
    kontrolna=0
    "$0"
    exit 0
    ;;
    *)
    echo "Niepoprawna opcja"
    sleep 1
    kontrolna=1
    ;;
    esac
    done
    #===================================================
    ;;


    "*" | 3)
    #===================================================
    #====================================
    
    kontrol=1
    while [ $kontrol = 1 ]; do
    clear
    echo -e "${AQUA}################"
    echo -e "${AQUA}###${RESET} Mnożenie ${AQUA}###"
    echo -e "${AQUA}################"
    echo " "
    echo -e "${BLUE}======================${RESET}"
    echo -e "${llime}> ${RED}1${BLUE}, ${RED}d ${BLUE}Dziesiętny"
    echo -e "${llime}> ${RED}2${BLUE}, ${RED}b ${BLUE}Dwójkowy"
    echo -e "${llime}> ${RED}3${BLUE}, ${RED}o ${BLUE}Ósemkowy"
    echo -e "${llime}> ${RED}4${BLUE}, ${RED}h ${BLUE}Szesnastkowy"
    echo -e "${llime}> ${RED}5 Exit"
    echo -e "${BLUE}======================${RESET}"
    echo -e "Podaj numer/symbol systemu liczbowego w którym chcesz wykonać obliczenia"
    read opt
    case $opt in
    "d" | 1)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    decymal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            decymal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "$pierwsza*($druga)" | bc)
                wynikb=$(echo "obase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynik" | bc)
                wynikh=$(echo "obase=16; $wynik" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "b" | 2)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    binary "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            binary "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=2; obase=2; $pierwsza*($druga)" | bc)
                wynikd=$(echo "ibase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "o" | 3)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    octal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            octal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=8; obase=8; $pierwsza*($druga)" | bc)
                wynikd=$(echo "ibase=8; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "h" | 4)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    hex "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            hex "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                pierwszaa=$(echo "$pierwsza" | tr 'a-f' 'A-F')
                drugaa=$(echo "$druga" | tr 'a-f' 'A-F')
                wynik=$(echo "ibase=16; $pierwszaa*($drugaa)" | bc)
                wynik=$(echo "obase=16; $wynik" | bc)
                wynikd=$(echo "ibase=16; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "exit" | "e" | "-e" | 5)
    kontrolna=0
    "$0"
    exit 0
    ;;
    *)
    echo "Niepoprawna opcja"
    sleep 1
    kontrolna=1
    ;;
    esac
    done
    #===================================================
    ;;
    "/" | 4)
    #===================================================
    #====================================
    
    kontrol=1
    while [ $kontrol = 1 ]; do
    clear
    echo -e "${AQUA}#################"
    echo -e "${AQUA}###${RESET} Dzielenie ${AQUA}###"
    echo -e "${AQUA}#################"
    echo " "
    echo -e "${BLUE}======================${RESET}"
    echo -e "${llime}> ${RED}1${BLUE}, ${RED}d ${BLUE}Dziesiętny"
    echo -e "${llime}> ${RED}2${BLUE}, ${RED}b ${BLUE}Dwójkowy"
    echo -e "${llime}> ${RED}3${BLUE}, ${RED}o ${BLUE}Ósemkowy"
    echo -e "${llime}> ${RED}4${BLUE}, ${RED}h ${BLUE}Szesnastkowy"
    echo -e "${llime}> ${RED}5 Exit"
    echo -e "${BLUE}======================${RESET}"
    echo -e "Podaj numer/symbol systemu liczbowego w którym chcesz wykonać obliczenia"
    read opt
    case $opt in
    "d" | 1)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    decymal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            decymal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "$pierwsza/$druga" | bc)
                wynikb=$(echo "obase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynik" | bc)
                wynikh=$(echo "obase=16; $wynik" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "b" | 2)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    binary "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            binary "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=2; obase=2; $pierwsza/$druga" | bc)
                wynikd=$(echo "ibase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "o" | 3)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    octal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            octal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=8; obase=8; $pierwsza/$druga" | bc)
                wynikd=$(echo "ibase=8; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "h" | 4)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    hex "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            hex "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                pierwszaa=$(echo "$pierwsza" | tr 'a-f' 'A-F')
                drugaa=$(echo "$druga" | tr 'a-f' 'A-F')
                wynik=$(echo "ibase=16; $pierwszaa/$drugaa" | bc)
                wynik=$(echo "obase=16; $wynik" | bc)
                wynikd=$(echo "ibase=16; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "exit" | "e" | "-e" | 5)
    kontrolna=0
    "$0"
    exit 0
    ;;
    *)
    echo "Niepoprawna opcja"
    sleep 1
    kontrolna=1
    ;;
    esac
    done
    #===================================================
    ;;
    "%" | 5)
    #===================================================
    #====================================
    
    kontrol=1
    while [ $kontrol = 1 ]; do
    clear
    echo -e "${AQUA}##########################"
    echo -e "${AQUA}###${RESET} Reszta z dzielenia ${AQUA}###"
    echo -e "${AQUA}##########################"
    echo " "
    echo -e "${BLUE}======================${RESET}"
    echo -e "${llime}> ${RED}1${BLUE}, ${RED}d ${BLUE}Dziesiętny"
    echo -e "${llime}> ${RED}2${BLUE}, ${RED}b ${BLUE}Dwójkowy"
    echo -e "${llime}> ${RED}3${BLUE}, ${RED}o ${BLUE}Ósemkowy"
    echo -e "${llime}> ${RED}4${BLUE}, ${RED}h ${BLUE}Szesnastkowy"
    echo -e "${llime}> ${RED}5 Exit"
    echo -e "${BLUE}======================${RESET}"
    echo -e "Podaj numer/symbol systemu liczbowego w którym chcesz wykonać obliczenia"
    read opt
    case $opt in
    "d" | 1)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    decymal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            decymal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "$pierwsza%$druga" | bc)
                wynikb=$(echo "obase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynik" | bc)
                wynikh=$(echo "obase=16; $wynik" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "b" | 2)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    binary "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            binary "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=2; obase=2; $pierwsza%$druga" | bc)
                wynikd=$(echo "ibase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "o" | 3)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    octal "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            octal "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                wynik=$(echo "ibase=8; obase=8; $pierwsza%$druga" | bc)
                wynikd=$(echo "ibase=8; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "h" | 4)
    #======================
    echo -e "${KOMUNICATE}Podaj pierwszą wartość:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    hex "$pierwsza"
        if [ $? = 0 ]; then
            echo -e "${KOMUNICATE}Podaj drugą wartość:${DATA}"
            read druga
            echo -e "${RESET}"
            hex "$druga"
            if [ $? = 0 ]; then
            kontrolna=0
                pierwszaa=$(echo "$pierwsza" | tr 'a-f' 'A-F')
                drugaa=$(echo "$druga" | tr 'a-f' 'A-F')
                wynik=$(echo "ibase=16; $pierwszaa%$drugaa" | bc)
                wynik=$(echo "obase=16; $wynik" | bc)
                wynikd=$(echo "ibase=16; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
            else
            kontrolna=1
        fi
        else
        kontrolna=1
        fi
    #======================
    ;;
    "exit" | "e" | "-e" | 5)
    kontrolna=0
    "$0"
    exit 0
    ;;
    *)
    echo "Niepoprawna opcja"
    sleep 1
    kontrolna=1
    ;;
    esac
    done
    #===================================================
    ;;
    
    6)
    #===================================================
    #====================================
    
    kontrol=1
    while [ $kontrol = 1 ]; do
    clear
    echo -e "${AQUA}#################"
    echo -e "${AQUA}###${RESET} Konwersja ${AQUA}###"
    echo -e "${AQUA}#################"
    echo " "
    echo -e "${BLUE}======================${RESET}"
    echo -e "${llime}> ${RED}1${BLUE}, ${RED}d ${BLUE}Dziesiętny"
    echo -e "${llime}> ${RED}2${BLUE}, ${RED}b ${BLUE}Dwójkowy"
    echo -e "${llime}> ${RED}3${BLUE}, ${RED}o ${BLUE}Ósemkowy"
    echo -e "${llime}> ${RED}4${BLUE}, ${RED}h ${BLUE}Szesnastkowy"
    echo -e "${llime}> ${RED}5 Exit"
    echo -e "${BLUE}======================${RESET}"
    echo -e "Podaj numer/symbol systemu liczbowego z którego chcesz konwertować:"
    read opt
    case $opt in
    "d" | 1)
    #======================
    echo -e "${KOMUNICATE}Podaj wartość do konwersji:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    decymal "$pierwsza"
        if [ $? = 0 ]; then    
            kontrolna=0
                wynik="$pierwsza"
                wynikb=$(echo "obase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynik" | bc)
                wynikh=$(echo "obase=16; $wynik" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        else
        kontrolna=1
        fi
    #======================
    ;;
    "b" | 2)
    #======================
    echo -e "${KOMUNICATE}Podaj wartość do konwersji:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    binary "$pierwsza"
        if [ $? = 0 ]; then    
            kontrolna=0
                wynik="$pierwsza"
                wynikd=$(echo "ibase=2; $wynik" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        else
        kontrolna=1
        fi
    #======================
    ;;
    "o" | 3)
    #======================
    echo -e "${KOMUNICATE}Podaj wartość do konwersji:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    octal "$pierwsza"
        if [ $? = 0 ]; then    
            kontrolna=0
                wynik="$pierwsza"
                wynikd=$(echo "ibase=8; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wynikh=$(echo "obase=16; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${BLUE} $wynikh"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        else
        kontrolna=1
        fi
    #======================
    ;;
    "h" | 4)
    #======================
    echo -e "${KOMUNICATE}Podaj wartość do konwersji:${DATA}"
    read pierwsza
    echo -e "${RESET}"
    hex "$pierwsza"
        if [ $? = 0 ]; then    
            kontrolna=0
                pierwszaa=$(echo "$pierwsza" | tr 'a-f' 'A-F')
                wynik="${pierwszaa}"
                wynik=$(echo "obase=16; ibase=16; $wynik" | bc)
                wynikd=$(echo "ibase=16; $wynik" | bc)
                wynikb=$(echo "obase=2; $wynikd" | bc)
                wyniko=$(echo "obase=8; $wynikd" | bc)
                echo " "
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dziesiętny:   ${llime}|${BLUE} $wynikd"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Dwójkowy:     ${llime}|${BLUE} $wynikb"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Ósemkowy:     ${llime}|${BLUE} $wyniko"
                echo -e "${llime}========================================${RESET}"
                echo -e "${YELLOW} Szesnastkowy: ${llime}|${YELLOW} $wynik"
                echo -e "${llime}========================================${RESET}"
                read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
        else
        kontrolna=1
        fi
    #======================
    ;;
    "exit" | "e" | "-e" | 5)
    kontrolna=0
    "$0"
    exit 0
    ;;
    *)
    echo "Niepoprawna opcja"
    sleep 1
    kontrolna=1
    ;;
    esac
    done
    #===================================================
    ;;

    "exit" | "e" | "-e" | 7)
    exit 0
    ;;
    
    *)
    echo "Niepoprawny argument operacji"
    sleep 1
    "$0"
    exit 0
    ;;
esac


