#!/bin/bash
#set -x
clear
RED='\033[0;31m'
BLUE='\033[38;5;45m'
RESET='\033[0m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
llime='\033[38;5;10m'
AQUA='\033[38;5;51m'
ROSE='\033[38;5;201m'

text1='\033[38;5;231m'
tlo1='\033[48;5;20m'
KOMUNICATE="${text1}${tlo1}"

text2='\033[38;5;17m'
tlo2='\033[48;5;123m'
DATA="${text2}${tlo2}"

sprawdz() {
    local wartosc="$1"

    # Zastąp znaki specjalne spacjami, aby ułatwić podział na tokeny
    wartosc="${wartosc//+/ + }"
    wartosc="${wartosc//-/ - }"
    wartosc="${wartosc//\*/ \* }"
    wartosc="${wartosc/// / / }"
    wartosc="${wartosc//\^/ \^ }"
    wartosc="${wartosc//%/ % }"
    wartosc="${wartosc//(/ ( }"
    wartosc="${wartosc//)/ ) }"

    # Podziel wyrażenie na tokeny
    IFS=' ' read -r -a tokens <<< "$wartosc"

    local poprawny=true
    for token in "${tokens[@]}"; do
        # Sprawdź, czy token jest liczbą, operatorem, funkcją sqrt() lub komórką
        if ! [[ "$token" =~ ^[-+]?([0-9]*\.[0-9]+|[0-9]+)$ || "$token" =~ ^[-+*/%^()]$ || "$token" = "sqrt" || "$token" = "()" || "$token" =~ ^\[M[1-4]\]$ ]]; then
            poprawny=false
            break
        fi
    done

    if $poprawny; then
        return 0
    else
        return 1
    fi
}

podmien_wartosci() {
    local wartosc="$1"
    wartosc=$(echo "$wartosc" | sed -e "s/\[M1\]/($m1)/g" -e "s/\[M2\]/($m2)/g" -e "s/\[M3\]/($m3)/g" -e "s/\[M4\]/($m4)/g")
    echo "$wartosc"
}

read m1 < ".rejestr/.m1.txt"
read m2 < ".rejestr/.m2.txt"
read m3 < ".rejestr/.m3.txt"
read m4 < ".rejestr/.m4.txt"

echo -e "${YELLOW}###############################"
echo -e "${YELLOW}###${ROSE} Kalkulator Zaawansowany ${YELLOW}###"
echo -e "${YELLOW}###############################"
echo " "
echo -e "${ROSE}============================"
echo -e "${YELLOW}Komórka ${ROSE}| Wartość"
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M1]  ${ROSE}| ${YELLOW}${m1} "
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M2]  ${ROSE}| ${YELLOW}${m2} "
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M3]  ${ROSE}| ${YELLOW}${m3} "
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M4]  ${ROSE}| ${YELLOW}${m4} "
echo -e "${ROSE}============================${RESET}"

echo " "
echo -e "${ROSE}Dostępne znaki: ${RED}(${ROSE} , ${RED})${ROSE} , ${RED}[${ROSE} , ${RED}]${ROSE} ,${RED} +${ROSE} , ${RED}-${ROSE} , ${RED}*${ROSE} , ${RED}/${ROSE} , ${RED}^${ROSE} , ${RED}%${ROSE} , ${RED}sqrt()${RESET}"
echo " "
echo -e "Podaj Wyrażenie Arytmetyczne wykorzystujące podane znaki lub komórki."
echo -e "Zachowaj poprawną składnię matematyczną. ${GREEN}[-c] Wyczyść Komórki${RESET}, ${RED}[-e] Exit${RESET}"
read -r a
if [ $a = "-e" ] || [ $a = "e" ] || [ $a = "exit" ] || [ $a = "Exit" ]; then
exit 0
fi
if [ $a = "-c" ] || [ $a = "c" ]; then
echo "0" > ".rejestr/.m1.txt"
echo "0" > ".rejestr/.m2.txt"
echo "0" > ".rejestr/.m3.txt"
echo "0" > ".rejestr/.m4.txt"
"$0"
exit 0
fi
echo " "
if sprawdz "$a"; then
echo " "
else
echo -e "wykryto błąd w składni, ${RED}Zakończono w stanie błędu${RESET}"
read -n 1 -s -r -p "Naciśnij dowolny klawisz, aby wyjść..."
"$0"
exit 0
fi

wartosc=$(podmien_wartosci "$a")
wynik=$(echo "scale=6; $wartosc" | bc -l)
wynik=$(echo $wynik | sed 's/\.0*$//; s/\.\([0-9]*[1-9]\)0*$/.\1/')
kontrol=1
while [ $kontrol = 1 ]; do
clear
echo -e "${YELLOW}=============================${RESET}"
echo -e "${ROSE} Wynik: $wynik"
echo -e "${YELLOW}=============================${RESET}"
echo " "
echo "Czy zapisać wynik do pamięci? [y/n]"
read opt
if [ "$opt" = "y" ]; then
echo " "
k=1
kontrol=0
while [ $k = 1 ]; do
clear
echo -e "${ROSE}============================"
echo -e "${YELLOW}Komórka ${ROSE}| Wartość"
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M1]  ${ROSE}| ${YELLOW}${m1} "
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M2]  ${ROSE}| ${YELLOW}${m2} "
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M3]  ${ROSE}| ${YELLOW}${m3} "
echo -e "${ROSE}============================"
echo -e "${YELLOW}  [M4]  ${ROSE}| ${YELLOW}${m4} "
echo -e "${ROSE}============================${RESET}"
echo " "
echo "Podaj nazwę komórki w której mam zapisać, ( np: [M1] )"
read kom
case $kom in
"[M1]")
k=0
echo "$wynik" > ".rejestr/.m1.txt"
echo "Zapisano pomyślnie"
sleep 1
"$0"
exit 0 
;;
"[M2]")
k=0
echo "$wynik" > ".rejestr/.m2.txt" 
echo "Zapisano pomyślnie"
sleep 1
"$0"
exit 0
;;
"[M3]")
k=0
echo "$wynik" > ".rejestr/.m3.txt" 
echo "Zapisano pomyślnie"
sleep 1
"$0"
exit 0
;;
"[M4]")
k=0
echo "$wynik" > ".rejestr/.m4.txt"
echo "Zapisano pomyślnie"
sleep 1
"$0"
exit 0 
;;
*)
echo "Niepoprawna nazwa komórki"
sleep 1
k=1
;;
esac
done
elif [ "$opt" = "n" ]; then
kontrol=0
"$0"
exit 0
else
echo "Niepoprawna opcja, użyj [y/n]"
sleep 1
kontrol=1
fi
done





